jQuery(document).ready(function($){
    var ju_object_queue = wpmf_object_queue;
    juCheckQueue = function() {
        var bar = $('#wp-admin-bar-'+ ju_object_queue.prefix +'-topbar span.' + ju_object_queue.prefix);
        $.ajax({
            url : ju_object_queue.ajaxurl,
            type : 'POST',
            data : {
                action: ju_object_queue.prefix + '_queue'
            },
            beforeSend : function(){
                bar.addClass(ju_object_queue.prefix + '-querying');
            },
            success : function(data){
                try {
                    data = JSON.parse(data);
                    bar.removeClass(ju_object_queue.prefix + '-orange '+ ju_object_queue.prefix +'-green '+ ju_object_queue.prefix +'-gray');
                    if (data.queue_length > 0) {
                        bar.addClass(ju_object_queue.prefix + '-orange');
                    } else {
                        bar.addClass(ju_object_queue.prefix + '-green');
                    }
                    if (parseInt(data.stop) === 1) {
                        $('#wp-admin-bar-'+ ju_object_queue.prefix +'-topbar span.' + ju_object_queue.prefix).addClass(ju_object_queue.prefix + '-gray');
                    }
                    $('.'+ ju_object_queue.prefix +'-queue').html(data.queue_length);
                    $('#wp-admin-bar-'+ ju_object_queue.prefix +'-topbar .'+ ju_object_queue.prefix +'-queue').attr('title', data.title);
                    $('.ju_queue_status_res').remove();
                    $('.ju-status-wrap .ju_queue_status').prepend(data.status_html);
                    if (parseInt(data.stop) === 1) {
                        $('.' + ju_object_queue.prefix + '_stop_queue').find('.dashicons').addClass('dashicons-controls-play').removeClass('dashicons-controls-pause');
                        $('.' + ju_object_queue.prefix + '_stop_queue').find('label').text(ju_object_queue.start_label);
                    } else {
                        $('.' + ju_object_queue.prefix + '_stop_queue').find('.dashicons').addClass('dashicons-controls-pause').removeClass('dashicons-controls-play');
                        $('.' + ju_object_queue.prefix + '_stop_queue').find('label').text(ju_object_queue.stop_label);
                    }
                } catch(err) {}
            },
            complete: function(){
                bar.removeClass(ju_object_queue.prefix + '-querying');
            }
        });
    };
    setTimeout(juCheckQueue, 1000);
    setInterval(juCheckQueue, 10 * 1000);
    // Initialize for check queue click
    $('#wp-admin-bar-'+ ju_object_queue.prefix +'-topbar a > span').click(function(e){
        e.preventDefault();
        juCheckQueue();
    });

    $('.' + ju_object_queue.prefix + '_clear_queue').on('click', function () {
        var $this = $(this);
        $.ajax({
            url : ju_object_queue.ajaxurl,
            type : 'POST',
            data : {
                action: ju_object_queue.prefix + '_clear_queue'
            },
            beforeSend : function(){
                $this.addClass('queue_running');
            },
            success : function(data){
                $this.removeClass('queue_running');
            }
        });
    });

    $('.' + ju_object_queue.prefix + '_clear_queue').on('click', function () {
        var $this = $(this);
        $.ajax({
            url : ju_object_queue.ajaxurl,
            type : 'POST',
            data : {
                action: ju_object_queue.prefix + '_clear_queue'
            },
            beforeSend : function(){
                $this.addClass('queue_running');
            },
            success : function(data){
                $this.removeClass('queue_running');
                $('.'+ ju_object_queue.prefix +'-queue').html(0);
                $('#wp-admin-bar-'+ ju_object_queue.prefix +'-topbar span.' + ju_object_queue.prefix).removeClass(ju_object_queue.prefix + '-orange').addClass(ju_object_queue.prefix + '-green');
            }
        });
    });

    $('.' + ju_object_queue.prefix + '_stop_queue').on('click', function () {
        var $this = $(this);
        var icon = $this.find('.dashicons');
        if (icon.hasClass('dashicons-controls-pause')) {
            $('#wp-admin-bar-'+ ju_object_queue.prefix +'-topbar span.' + ju_object_queue.prefix).addClass(ju_object_queue.prefix + '-gray');
            icon.addClass('dashicons-controls-play').removeClass('dashicons-controls-pause');
            $this.find('label').text(ju_object_queue.start_label);
        } else {
            $('#wp-admin-bar-'+ ju_object_queue.prefix +'-topbar span.' + ju_object_queue.prefix).removeClass(ju_object_queue.prefix + '-gray');
            icon.addClass('dashicons-controls-pause').removeClass('dashicons-controls-play');
            $this.find('label').text(ju_object_queue.stop_label);
        }
        $.ajax({
            url : ju_object_queue.ajaxurl,
            type : 'POST',
            data : {
                action: ju_object_queue.prefix + '_stop_queue'
            },
            success : function(data){
                $this.removeClass('queue_running');
            }
        });
    });
});