<?php
/**
 * Theme functions and definitions
 *
 * @package HelloElementorChild
 */

/**
 * Load child theme css and optional scripts
 *
 * @return void
 */
function hello_elementor_child_enqueue_scripts() {
	wp_enqueue_style(
		'hello-elementor-child-style',
		get_stylesheet_directory_uri() . '/style.css',
		[
			'hello-elementor-theme-style',
		],
		'1.0.0'
	);
}
add_action( 'wp_enqueue_scripts', 'hello_elementor_child_enqueue_scripts' );


/**
 * Change the Footer in WordPress Admin Panel
 */
function remove_footer_admin () {
echo 'Creat de <a href="https://www.facebook.com/vibu.code" target="_blank">ViBu</a> | Contact: <a href="https://m.me/vitalie.butnaru" target="_blank">Messenger
</a></p>';
}
add_filter('admin_footer_text', 'remove_footer_admin');


/**
 * Change user email for the User Registration addon.
 *
 * @link https://wpforms.com/developers/change-user-email-for-user-registration-addon/
 *
 * @param  array $email
 * @return array
 */
function wpf_dev_user_registration_user_email( $email ) {
 
    $blogname = wp_specialchars_decode( get_option( 'blogname' ), ENT_QUOTES );
 
    // Set the email subject line
    $email['subject']  = sprintf( __( '[%s] Informațiile despre numele dvs. de utilizator și parola' ), $blogname );
 
    // The primary part of the email message consists of providing the user
    // with their username, password, and login URL.
    $email['message'] = sprintf( __( 'Username: %s' ), $email['user']->user_login ) . "\r\n";
        $email['message'] .= sprintf( __( 'Parla: %s' ), $email['password'] ) . "\r\n\r\n";
    $email['message'] .= wp_login_url() . "\r\n\r\n";
 
    // Add more details if to the email message if user activation is enabled
    if ( $email['activation'] ) {
 
        // Append "Activation Required" to the existing email subject line
        $email['subject'] .= __( ' (Activare cont necesară)', 'wpforms_user_registration' );
 
        // If activation method is User Email
        if ( 'user' == $email['activation']  ) {
            $email['message'] .= __( 'IMPORTANT: Activați contul înainte de a vă putea autentifica. Vă rugăm să vizitați linkul de mai jos.', 'wpforms_user_registration' ) . "\r\n";
            $email['message'] .= $email['link'];
        // If activation method is Manual Approval
        } else {
            $email['message'] .= __( 'Administratorul site-ului trebuie să vă activeze contul înainte de a vă putea autentifica.', 'wpforms_user_registration' ) . "\r\n";
        }
    }
 
    return $email;
}
add_filter( 'wpforms_user_registration_email_user', 'wpf_dev_user_registration_user_email', 10, 1 );


/**
 * Randomly Change Background Color
 */
function wpb_bg() { 
$rand = array('0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f');
$color ='#'.$rand[rand(0,15)].$rand[rand(0,15)].$rand[rand(0,15)].
$rand[rand(0,15)].$rand[rand(0,15)].$rand[rand(0,15)];
//echo $color;
}

/**
 * Hide Login Errors in WordPress
 */
function no_wordpress_errors(){
  return 'Ceva nu ai introdus corect amice! Verifică corectitudinea sau contactează WebMaster-ul ;)';
}
add_filter( 'login_errors', 'no_wordpress_errors' );

// Disable Search Feature in WordPress
function fb_filter_query( $query, $error = true ) {
 
if ( is_search() ) {
$query->is_search = false;
$query->query_vars[s] = false;
$query->query[s] = false;
 
// to error
if ( $error == true )
$query->is_404 = true;
}
}
 
add_action( 'parse_query', 'fb_filter_query' );
add_filter( 'get_search_form', create_function( '$a', "return null;" ) );

//Remove Welcome Panel from WordPress Dashboard
remove_action('welcome_panel', 'wp_welcome_panel');

// Show Total Number of Registered Users in WordPress
// Function to return user count
function wpb_user_count() { 
$usercount = count_users();
$result = $usercount['total_users']; 
return $result; 
} 
// Creating a shortcode to display user count
add_shortcode('user_count', 'wpb_user_count');


//Add Additional File Types to be Uploaded in WordPress
// function my_myme_types($mime_types){
//     $mime_types['svg'] = 'image/svg+xml'; //Adding svg extension
//     $mime_types['psd'] = 'image/vnd.adobe.photoshop'; //Adding photoshop files
//     return $mime_types;
// }
// add_filter('upload_mimes', 'my_myme_types', 1, 1);

//Limit Dashboard Access With Code
 //add_action( 'init', 'blockusers_init' ); function blockusers_init() { if ( is_admin() && ! current_user_can( //'administrator' ) && ! ( defined( 'DOING_AJAX' ) && DOING_AJAX ) ) { wp_redirect( home_url() ); exit; } } 


//________________________________________________________________________


/* --------------------------------------------------*/
/* Disable the emoji's
/* --------------------------------------------------*/
if(!function_exists('bm_disable_emojis')){
	function bm_disable_emojis() {
		remove_action( 'wp_head', 'print_emoji_detection_script', 7 );
		remove_action( 'admin_print_scripts', 'print_emoji_detection_script' );
		remove_action( 'wp_print_styles', 'print_emoji_styles' );
		remove_action( 'admin_print_styles', 'print_emoji_styles' );    
		remove_filter( 'the_content_feed', 'wp_staticize_emoji' );
		remove_filter( 'comment_text_rss', 'wp_staticize_emoji' );  
		remove_filter( 'wp_mail', 'wp_staticize_emoji_for_email' );
		add_filter( 'tiny_mce_plugins', 'bm_disable_emojis_tinymce' );
	}
}
add_action( 'init', 'bm_disable_emojis' );


// FUNCTIE CARE NU DA VOIE SA INCARCI IMAGINI MARI
function whero_limit_image_size($file) {

// Calculate the image size in KB
$image_size = $file['size']/1024;

// File size limit in KB
$limit = 512;

// Check if it's an image
$is_image = strpos($file['type'], 'image');

if ( ( $image_size > $limit ) && ($is_image !== false) )
        $file['error'] = 'Atenție!!!! Imaginea este GIGANTICĂ. Pentru o încărcare reușită imaginea trebuie să fie mai mică decât '. $limit .'KB' . '-  link util pentru compresare:  ' . ">>  https://www.img2go.com/compress-image ";

return $file;

}
add_filter('wp_handle_upload_prefilter', 'whero_limit_image_size');

//I added following filter hook which replaces the image, if image with same name already exists. 
add_filter( 'sanitize_file_name', 'replace_image_if_same_exists', 10, 1 );

function replace_image_if_same_exists( $name ) 
{
  $args = array(
    'numberposts'   => -1,
    'post_type'     => 'attachment',
    'meta_query' => array(
            array( 
                'key' => '_wp_attached_file',
                'value' => $name,
                'compare' => 'LIKE'
            )
        )
  );
  $attachments_to_remove = get_posts( $args );

  foreach( $attachments_to_remove as $attach )
    wp_delete_attachment( $attach->ID, true );

 return $name;
}


// remove version info from head and feeds
function generator_version_removal() {
    return '';
}
add_filter('the_generator', 'generator_version_removal');

//________________________________________________________________________


define( 'DISALLOW_FILE_EDIT', true);

function remove_menus(){

  remove_menu_page( 'index.php' );                  //Dashboard
//   remove_menu_page( 'jetpack' );                    //Jetpack*
//   remove_menu_page( 'edit.php' );                   //Posts
//   remove_menu_page( 'upload.php' );                 //Media
//remove_menu_page( '/wp-admin/index.php' );    //DASHBOARD
//   remove_menu_page( 'edit-comments.php' );          //Comments
//   remove_menu_page( 'themes.php' );                 //Appearance
//   remove_menu_page( 'plugins.php' );                //Plugins
//   remove_menu_page( 'users.php' );                  //Users
//   remove_menu_page( 'tools.php' );                  //Tools
//   remove_menu_page( 'options-general.php' );        //Settings
//   remove_menu_page( 'wpcf7' );        //contact for


}
if(current_user_can( 'author' )){
add_action( 'admin_menu', 'remove_menus' );
}



//Replace "Howdy" with your text in wordpress admin bar
function replace_howdy_with_your_text( $wp_admin_bar ) {
	$account_info=$wp_admin_bar->get_node('my-account');
	$your_title = str_replace( 'Howdy,', 'Salutare ', $account_info->title );
	$wp_admin_bar->add_node( array(
    	'id' => 'my-account',
    	'title' => $your_title,
	) );
}
add_filter( 'admin_bar_menu', 'replace_howdy_with_your_text', 25 );

//Change wordpress dashboard footer text
// function custom_footer_admin_text () {
//      	 echo "Creat și întreținut de: CNC.MD";
//   }
//   add_filter('admin_footer_text', 'custom_footer_admin_text');
  
  
// Pages Titles
function my_admin_title($admin_title, $title)
{
    return get_bloginfo('name').' &bull; '.$title;
}
add_filter('admin_title', 'my_admin_title', 10, 2);
add_filter('login_title', 'my_admin_title', 10, 2);

//remove wp version from backend
function my_footer_shh() {
    if ( ! current_user_can('manage_options') ) { // 'update_core' may be more appropriate
        remove_filter( 'update_footer', 'core_update_footer' ); 
    }
}
add_action( 'admin_menu', 'my_footer_shh' );

// DISABLE SEARCH IN WP
function wpb_filter_query( $query, $error = true ) {
if ( is_search() ) {
$query->is_search = false;
$query->query_vars[s] = false;
$query->query[s] = false;
if ( $error == true )
$query->is_404 = true;
}
}
add_action( 'parse_query', 'wpb_filter_query' );
add_filter( 'get_search_form', create_function( '$a', "return null;" ) );
function remove_search_widget() {
    unregister_widget('WP_Widget_Search');
}
add_action( 'widgets_init', 'remove_search_widget' );
//remove image/attachments links testuletz here
// function wpb_imagelink_setup() {
//     $image_set = get_option( 'image_default_link_type' );
     
//     if ($image_set !== 'none') {
//         update_option('image_default_link_type', 'none');
//     }
// }
// add_action('admin_init', 'wpb_imagelink_setup', 10);