<?php
/**
 * Plugin Name: Hide Update Notifications
 * Plugin URI: https://cssigniter.com
 * Description: A small plugin to hide WordPress core update notifications from all users except administrators.
 * Version: 1.0
 * Author: cssigniter
 * Author URI: https://cssigniter.com
 * License: GPLv2 or later
 * License URI: http://www.gnu.org/licenses/gpl-2.0.html
 */

function hide_core_update_notifications_from_users() {
	if ( ! current_user_can( 'update_core' ) ) {
		remove_action( 'admin_notices', 'update_nag', 3 );
		remove_action( 'admin_notices', 'maintenance_nag', 10 );
	}
}
add_action( 'admin_head', 'hide_core_update_notifications_from_users', 1 );